import {
    fetchAds,
    fetchCategories,
    fetchCategoryList,
    fetchCategoryPosts,
} from '@/actions/fetchPost'

import Heading from '@/components/Heading'

import React from 'react'
import PostBlock from '@/components/PostBlock'

import BigPostBlock from '@/components/BigPostBlock'

import Link from 'next/link'

import NotFoundPage from '../not-found'
import { APP_URL_STORAGE } from '@/constant/apiEndpoints'

export const revalidate = 300

// export const dynamicParams = true

export async function generateStaticParams() {
    const categories = await fetchCategories()

    return categories.map(category => ({
        category: category.slug,
        searchParams: { page: 1 },
    }))
}

async function Category({ params, searchParams }) {
    const { category } = await params

    const pageNumber = await searchParams

    pageNumber.page = pageNumber.page || 1

    const posts = await fetchCategoryPosts(category, pageNumber.page)
    const mustRead = await fetchCategoryPosts('must-read', 1)
    const categories = await fetchCategoryList(category)

    const ads = await fetchAds()

    if (posts.data === undefined) {
        return <NotFoundPage />
    }

    return (
        <div>
            <div className=" px-2 sm:px-32 mt-2 flex gap-6 flex-col sm:flex-row">
                <div className="max-w-5xl w-full">
                    <div className="flex my-2 bg-gray-900">
                        <div
                            className="bg-red-600 scale-110 text-white font-bold p-2 pr-4 "
                            style={{
                                clipPath:
                                    'polygon(0px 0px, 90% 0px, 100% 50%, 90% 100%, 0px 100%, 0% 50%)',
                            }}>
                            <span>{categories?.category.name}</span>
                        </div>
                        <div className="bg-gray-900 p-2 text-white flex gap-4 overflow-x-scroll no-scrollbar w-full ">
                            {categories?.categoryWithChildren &&
                                categories.categoryWithChildren.map(
                                    category => (
                                        <Link
                                            href={`/${category.slug}`}
                                            key={category.id}>
                                            {category.name}
                                        </Link>
                                    ),
                                )}
                        </div>
                    </div>
                    {/* <Heading title={categories?.category.name} /> */}
                    <div className="grid grid-cols-1  sm:grid-cols-2 gap-1 sm:grid-rows-6">
                        {posts &&
                            posts?.data?.map((post, index) =>
                                index === 0 ? (
                                    <BigPostBlock post={post} key={post.id} />
                                ) : (
                                    <div className="mt-2" key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ),
                            )}
                    </div>
                    {/* <div>
                        <Pagination>
                            <PaginationContent>
                                <PaginationItem>
                                    {posts.links.prev ? (
                                        <Link
                                            className="flex gap-1 items-center p-2 rounded"
                                            href={
                                                `/${category}?page=` +
                                                posts.links.prev.split('=')[1]
                                            }>
                                            <ChevronLeft size={18} />
                                            <span className="text-sm">
                                                Previous
                                            </span>
                                        </Link>
                                    ) : (
                                        <Link
                                            className="flex gap-1 items-center pointer-events-none bg-muted p-2 rounded"
                                            href="#">
                                            <ChevronLeft size={18} />
                                            <span className="text-sm">
                                                Previous
                                            </span>
                                        </Link>
                                    )}
                                </PaginationItem>
                                <PaginationItem>
                                    <PaginationLink
                                        href={`/${category}?page=1`}>
                                        1
                                    </PaginationLink>
                                </PaginationItem>
                                <PaginationItem>
                                    <PaginationEllipsis />
                                </PaginationItem>
                                <PaginationItem>
                                    {posts.links.next ? (
                                        <Link
                                            className="flex gap-1 items-center p-2 rounded"
                                            href={
                                                `/${category}?page=` +
                                                posts.links.next.split('=')[1]
                                            }>
                                            <span className="text-sm">
                                                Next
                                            </span>
                                            <ChevronRight size={18} />
                                        </Link>
                                    ) : (
                                        <Link
                                            className="flex gap-1 items-center pointer-events-none bg-muted p-2 rounded"
                                            href="#">
                                            <span className="text-sm">
                                                Next
                                            </span>
                                            <ChevronRight size={18} />
                                        </Link>
                                    )}
                                </PaginationItem>
                            </PaginationContent>
                        </Pagination>
                    </div> */}
                </div>
                <div className=" w-full sm:max-w-xs">
                    <div className=" grid place-content-center w-full  text-black aspect-square p-2">
                        <p className="text-xs text-end">Advertisment</p>
                        {ads?.square_ad_2 && (
                            <img
                                src={`${APP_URL_STORAGE}/${ads.square_ad_2}`}
                                alt="ads"
                                className="w-full h-full"
                            />
                        )}
                    </div>
                    <div className="mt-4">
                        <Heading title={'जरूर पढ़ें'} />
                        <div className="grid  grid-cols-1 gap-1 ">
                            {mustRead &&
                                mustRead?.data?.map(post => (
                                    <div key={post.id}>
                                        <PostBlock post={post} />
                                    </div>
                                ))}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Category
